#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/WtyyDm


float sdSegment( in vec2 p, in vec2 a, in vec2 b )
{
    vec2 pa = p-a, ba = b-a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h );
}

vec2 random2( vec2 p ) {
    return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

float invLerp(float from, float to, float value){
  return (value - from) / (to - from);
}



float saturate(float value)
{
    return clamp(value, 0.0, 1.0);
}


vec3 saturate(vec3 value)
{
    return clamp(value, vec3(0.0), vec3(1.0));
}

float point(vec2 current, vec2 target)
{    
    return smoothstep(0.0, 1.4, 0.01 / distance(current, target));
}

float pointInLine(vec2 current, vec2 target)
{    
    return smoothstep(0.0, 1.6, 0.01 / distance(current, target));
}

float line(vec2 point, vec2 a, vec2 b)
{
    float lineDistance = abs(sdSegment(point, a, b));    
    float lineLength = smoothstep(2.0, 0.2, distance(a, b));
    return saturate(smoothstep(0.01, 0.0, lineDistance) * lineLength);
}

float lineNoDistanceFade(vec2 point, vec2 a, vec2 b)
{    
    float lineDistance = abs(sdSegment(point, a, b));    
    return saturate(smoothstep(0.005, 0.0, lineDistance));
}

vec4 positionsForTime(float time, float scale)
{
    float offseted = time + 0.05;
    
    vec4 positions;
    positions.xy = random2(vec2(time, time));       
    positions.zw = random2(vec2(offseted, offseted));    
    
    positions *= scale;
    
    positions.zw *= 1.2;
    return positions;
}

const int indexPerDifference[] = int[8]
(
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7
);

int indexFromDifference(vec2 difference)
{
    float preIndex = difference.x * 3.0 + difference.y;
    
    preIndex -= max(sign(preIndex), 0.0);
    int index = int(preIndex) + 4;        
    
    return indexPerDifference[index];
}




int inLine(vec2 start, vec2 end, vec2 position, int head, out vec4 positions)
{
    int x = int(start.x);
    int y = int(start.y);
    
    int dx = abs(x - int(end.x));
    int dy = abs(y - int(end.y));
    
    int sx = start.x < end.x ? 1 : -1;
    int sy = start.y < end.y ? 1 : -1;
    
    int err = (dx > dy ? dx : -dy) / 2;
    
    
    int index = head+1;
    while(index > 0)
    {   
        positions.xy = vec2(x, y);
        int e2 = err;
        
        if (e2 > -dx)
        {
            err -= dy;
            x += sx;
        }
        
        if (e2 < dy)
        {
            err += dx;
            y += sy;
        }
        index--;
    }
    
    positions.zw = vec2(x, y);
    vec2 difference = abs(positions.zw - position);
    vec2 difference2 = abs(positions.xy - position);
    vec2 add = difference2 + difference;
    
    if(difference.x == 0.0 && difference.y == 0.0)
        return 1;
    else if(difference2.x == 0.0 && difference2.y == 0.0)
        return 3;
    else if(add == vec2(1.0, 1.0))
        return 2;
    else
        return 0;
}

vec3 flashLines(in vec2 cell, in vec2 cellInner, in vec2 positions[8], float scale, vec2 cellInnerCoordinates)
{    
    float timeScaled = iTime * 1.1;
    float floorTime = floor(timeScaled);    
    
    
    if(random2(vec2(floorTime, floorTime)).x > 0.2)
        return vec3(0.0);
    
    float time = fract(timeScaled);
    
    vec4 headCells;
    
    vec4 timedPositions = positionsForTime(floorTime, scale);
    timedPositions.yw += iTime * 0.15;
    
    vec4 flooredPositions = floor(timedPositions);    
    float distanceBetweenPositions = distance(flooredPositions.xy, flooredPositions.zw);    
    vec2 difference = abs(flooredPositions.zw - flooredPositions.xy);
    float amount = max(difference.x, difference.y);
    float ti = amount * time;
    
    int result = inLine(timedPositions.xy, timedPositions.zw, cell, int(ti), headCells);
    
    if(result == 0)
        return vec3(0.0);
    else
    {
        vec2 positionA;
        vec2 positionB;
        vec3 pointAndLine;
        
        if(result == 1)
        {
            
            positionA = positions[indexFromDifference(headCells.xy - cell)];                        
            positionB = cellInner;
            pointAndLine.x = point(cellInnerCoordinates, cellInner); 
        }
        else if (result == 2)
        {   
            headCells -= cell.xyxy;
            
            positionA = positions[indexFromDifference(headCells.xy)];
            positionB = positions[indexFromDifference(headCells.zw)];    
        }
        else if(result == 3)
        {           
            positionB = positions[indexFromDifference(headCells.zw - cell)]; 
            positionA = cellInner;              
            pointAndLine.x = point(cellInnerCoordinates, cellInner);                                    
        }
    
        pointAndLine.y = lineNoDistanceFade(cellInnerCoordinates, positionA, positionB);    
        vec2 mid = mix(positionA, positionB, fract(ti));
        pointAndLine.z = pointInLine(cellInnerCoordinates, mid);    
        return pointAndLine;
    }         
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xx;
    
    float scale = 10.0;

    uv *= scale;
    uv.y += iTime * 0.15;
    
    vec2 cellNumber = floor(uv);
    vec2 cellInnerCoordinates = fract(uv);
    
    vec2 actualCell, randomPoint;
    vec2 addedCell;    
    
    float points = 0.0;
    float lines = 0.0;
    
    vec2 centeredPoint = random2(cellNumber);    
    centeredPoint = 0.5 + 0.5*sin(iTime + 6.2831*centeredPoint );
    
    vec2 pointPositions[8];
    vec2 actualPositions[8];
    
    int index = 0;
    
    for(int x = -1; x <= 1; x++)
        for(int y = -1; y <= 1; y++)
        {                
            if(x == 0 && y == 0)
                continue;
            addedCell = vec2(float(x), float(y));            
            actualCell = cellNumber + addedCell;
            randomPoint = random2(actualCell);            
            randomPoint = 0.5 + 0.5 * sin(iTime + 6.2831 * randomPoint);
            pointPositions[index] = addedCell + randomPoint;
            actualPositions[index] = actualCell;
            index++;
        }
    
    for(index = 0; index < 8; index++)
    {
        vec2 randomPoint = pointPositions[index];                    
        lines += line(cellInnerCoordinates, centeredPoint, randomPoint);
        points += point(randomPoint, cellInnerCoordinates);      
    }
    
    points += point(centeredPoint, cellInnerCoordinates);        
      
    vec2 top = pointPositions[1];
    vec2 left = pointPositions[3];
    vec2 right = pointPositions[4];  
    vec2 bottom = pointPositions[6];
    
    // Left top    
    lines += line(cellInnerCoordinates, left, top);    
   
    // Left bottom    
    lines += line(cellInnerCoordinates, left, bottom);
    
    // Right top      
    lines += line(cellInnerCoordinates, right, top);
    
    // Right bottom    
    lines += line(cellInnerCoordinates, right, bottom);
    
    
    //vec3 color = vec3(0.015 / minimumDistance);
    vec3 color;
    
    vec3 flash = flashLines(cellNumber, centeredPoint, pointPositions, scale, cellInnerCoordinates);    
       
    vec3 co = vec3(0.83, 0.15, 0.455);
   
    color.rgb += points;
    color.rgb += vec3(0.0, 0.45, 0.9) * lines;
    
    
    color.rgb = mix(vec3(0.0), vec3(0.0, 0.45, 0.9), lines);
    
    color.rgb = mix(color.rgb, co, flash.x + flash.y * 0.35 + flash.z * .5); 
    color.rgb = mix(color.rgb, vec3(1.0), saturate(flash.x * 1.05 - .4) +  saturate(flash.y * 0.35 * 1.5 - 0.625) + saturate(flash.z * 1.05 - 0.625) + points);
    
    // Draw grid
    //color.r += step(cellInnerCoordinates.x, 0.02) + step(cellInnerCoordinates.y, 0.02);
  
    // Output to screen
    fragColor = vec4(color, 1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


